// PWDChangeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PWDChangeDlg.h"
#include "Include/CommonFun.h"
#include "Include/CLS_NVDSDK_Interface.h"


// CPWDChangeDlg dialog

IMPLEMENT_DYNAMIC(CPWDChangeDlg, CDialog)

CPWDChangeDlg::CPWDChangeDlg(LONG _lLogonID, CWnd* pParent /*=NULL*/)
: CDialog(CPWDChangeDlg::IDD, pParent)
, m_lLogonID(_lLogonID)
{

}

CPWDChangeDlg::~CPWDChangeDlg()
{
}

void CPWDChangeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_USERNAME, m_CboUserName);
	DDX_Control(pDX, IDC_EDIT_PWD, m_EditPwd);
	DDX_Control(pDX, IDC_EDIT_NEWPWD, m_EditNewPwd1);
	DDX_Control(pDX, IDC_EDIT_NEWPWD1, m_EditNewPwd2);

}


BEGIN_MESSAGE_MAP(CPWDChangeDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_CHGPWD, &CPWDChangeDlg::OnBnClickedButtonChgpwd)
	ON_BN_CLICKED(IDC_BUTTON_CHG_CANCEL, &CPWDChangeDlg::OnBnClickedButtonChgCancel)
END_MESSAGE_MAP()


// CPWDChangeDlg message handlers
void CPWDChangeDlg::OnBnClickedButtonChgpwd()
{
	// TODO: Add your control notification handler code here
	CString		strUserName;
	//GetDlgItem(IDC_COMBO_USERNAME)->;
	m_CboUserName.GetLBText(0, strUserName);
	CString		strPwd;
	GetDlgItem(IDC_EDIT_PWD)->GetWindowText(strPwd);
	CString		strNewPwd1;
	GetDlgItem(IDC_EDIT_NEWPWD)->GetWindowText(strNewPwd1);
	CString		strNewPwd2;
	GetDlgItem(IDC_EDIT_NEWPWD1)->GetWindowText(strNewPwd2);

	if (strPwd.GetLength() == 0)
	{
		MessageBox(GetText(IDS_MAIN_PWD_EMPTY));
		m_EditPwd.SetFocus();

		return;
	}
	if (strNewPwd1.GetLength() == 0)
	{
		MessageBox(GetText(IDS_MAIN_PWD_EMPTY));
		m_EditNewPwd1.SetFocus();

		return;
	}
	if (strNewPwd2.GetLength() == 0)
	{
		MessageBox(GetText(IDS_MAIN_PWD_EMPTY));
		m_EditNewPwd2.SetFocus();

		return;
	}

	if (strNewPwd1 != strNewPwd2)
	{
		MessageBox(GetText(IDS_MSG_CONFIRM_PWD));
		m_EditNewPwd1.SetFocus();

		return;
	}

	int iRet = DEC_ClientUserChangePassword(m_lLogonID, strUserName.GetBuffer(), strPwd.GetBuffer(), strNewPwd1.GetBuffer());
	if (iRet < 0)
	{
		AddLog(LOG_LEVEL_DEBUG, "Change password failed, return(%d).", iRet);
	}

	OnOK();
}

void CPWDChangeDlg::OnBnClickedButtonChgCancel()
{
	// TODO: Add your control notification handler code here
	OnCancel();
}

BOOL CPWDChangeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	m_CboUserName.AddString(_T("Admin"));
	m_CboUserName.SetCurSel(0);
	m_CboUserName.EnableWindow(FALSE);

	SetDlgItemText(IDC_STATIC_USER, GetText(IDS_MAIN_USERNAME));
	SetDlgItemText(IDC_STATIC_PWD, GetText(IDS_MAIN_PASSWORD));
	SetDlgItemText(IDC_STATIC_NEWPWD, GetText(IDS_CHGPWD_NEWPWD1));
	SetDlgItemText(IDC_STATIC_NEWPWD1, GetText(IDS_CHGPWD_NEWPWD2));
	SetDlgItemText(IDC_BUTTON_CHGPWD, GetText(IDS_NVS_INFO_OK));
	SetDlgItemText(IDC_BUTTON_CHG_CANCEL, GetText(IDS_CHGPWD_CANCEL));
	SetWindowText(GetText(IDS_CHGPWD_CHANGE));

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
